<?php
// Set headers for M-Pesa API communication
header("Content-Type: application/json");

// --- 1. M-PESA API DATA HANDLING ---
// Read the raw JSON data sent by M-Pesa
$mpesaResponse = file_get_contents('php://input');
$data = json_decode($mpesaResponse, true);

// Check for data presence and required keys
if (!isset($data['Body']['stkCallback']['CallbackMetadata']['Item'])) {
    // Log unexpected data structure
    error_log(date('Y-m-d H:i:s') . " - Unexpected Mpesa data: " . $mpesaResponse . "\n", 3, 'mpesa_log.log');
    
    // M-Pesa requires a specific JSON response even if processing fails
    echo json_encode(['ResultCode' => 0, 'ResultDesc' => 'Accepted']);
    exit;
}

// Extract transaction details
$transData = $data['Body']['stkCallback']['CallbackMetadata']['Item'];

$transactionDetails = [];
foreach ($transData as $item) {
    $transactionDetails[$item['Name']] = $item['Value'];
}

// Extract required fields
$transID = $transactionDetails['MpesaReceiptNumber'] ?? 'NO_RECEIPT';
$amount = $transactionDetails['Amount'] ?? 0.00;
// CRITICAL: BillRefNumber now contains the Borrower's ID Number (from borrowers.city)
$borrowerIdNumber = $transactionDetails['BillRefNumber'] ?? 'NO_REF'; 

// Extract date and time from the M-Pesa timestamp
$rawTime = $transactionDetails['TransTime'] ?? date('YmdHis');
$date = date('Y-m-d', strtotime($rawTime));
$time = date('H:i:s', strtotime($rawTime));
$year = date('Y', strtotime($rawTime));
$month = date('m', strtotime($rawTime));

// --- 2. DATABASE CONNECTION & LOOKUP ---
// REPLACE THESE WITH YOUR LIVE DATABASE CREDENTIALS!
// *************************************************************************
$servername = "localhost"; 
$dbUsername = "tirakeng_demo"; 
$dbPassword = "Websites@2020";
$dbname = "tirakeng_demo";
// *************************************************************************

$conn = new mysqli($servername, $dbUsername, $dbPassword, $dbname);

if ($conn->connect_error) {
    error_log(date('Y-m-d H:i:s') . " - DB Connection failed: " . $conn->connect_error, 3, 'mpesa_log.log');
    echo json_encode(['ResultCode' => 0, 'ResultDesc' => 'Accepted']);
    exit;
}

// --- 3. FIND BORROWER AND SAVINGS ACCOUNT ---
$borrower_id = 0;
$savings_id = 0;
$old_balance = 0.00;
$SAVINGS_PRODUCT_ID = 1; // Required saving product ID

// Sub-Query 1: Find borrower_id using the ID number (from borrowers.city)
$stmt = $conn->prepare("SELECT id FROM borrowers WHERE city = ?");
$stmt->bind_param("s", $borrowerIdNumber);
$stmt->execute();
$result = $stmt->get_result();
$borrowerRow = $result->fetch_assoc();

if (!$borrowerRow) {
    error_log(date('Y-m-d H:i:s') . " - Borrower ID Number not found: " . $borrowerIdNumber . "\n", 3, 'mpesa_log.log');
    $conn->close();
    echo json_encode(['ResultCode' => 0, 'ResultDesc' => 'Accepted']);
    exit;
}

$borrower_id = $borrowerRow['id'];

// Sub-Query 2: Find the required Savings ID and current balance for that borrower
$stmt = $conn->prepare("SELECT id, balance FROM savings WHERE borrower_id = ? AND savings_product_id = ?");
$stmt->bind_param("ii", $borrower_id, $SAVINGS_PRODUCT_ID);
$stmt->execute();
$result = $stmt->get_result();
$savingsRow = $result->fetch_assoc();

if (!$savingsRow) {
    error_log(date('Y-m-d H:i:s') . " - Savings Account (Product ID 1) not found for Borrower ID: " . $borrower_id . "\n", 3, 'mpesa_log.log');
    $conn->close();
    echo json_encode(['ResultCode' => 0, 'ResultDesc' => 'Accepted']);
    exit;
}

$savings_id = $savingsRow['id'];
$old_balance = $savingsRow['balance'];
$new_balance = $old_balance + $amount;


// --- 4. INSERT INTO savings_transactions ---
$sql = "INSERT INTO `savings_transactions` 
    (`user_id`, `borrower_id`, `savings_id`, `amount`, `type`, `system_interest`, `date`, `time`, `year`, `month`, 
    `notes`, `created_at`, `updated_at`, `branch_id`, `receipt`, `payment_method_id`, `debit`, `credit`, `balance`, 
    `reversible`, `reversed`, `reversal_type`, `reference`) 
    VALUES 
    (?, ?, ?, ?, 'deposit', '0', ?, ?, ?, ?, 
    'Paid Via Mpesa Api', NOW(), NOW(), '1', ?, '1', '0.0000', ?, ?, 
    '1', '0', 'none', '0')";

$stmt = $conn->prepare($sql);

// Bind the values
$stmt->bind_param("iidssssisd", 
    $user_id = 2,           // user_id 
    $borrower_id,           // borrower_id 
    $savings_id,            // savings_id 
    $amount,                // amount
    $date,                  // date
    $time,                  // time
    $year,                  // year
    $month,                 // month
    $transID,               // receipt 
    $amount,                // credit
    $new_balance            // balance
);

if ($stmt->execute()) {
    // --- 5. UPDATE SAVINGS ACCOUNT BALANCE ---
    $updateStmt = $conn->prepare("UPDATE savings SET balance = ? WHERE id = ?");
    $updateStmt->bind_param("di", $new_balance, $savings_id);
    $updateStmt->execute();

    // Log success
    error_log(date('Y-m-d H:i:s') . " - Transaction SUCCESS for Borrower ID $borrower_id, Savings ID $savings_id, Amount $amount, Receipt $transID\n", 3, 'mpesa_log.log');
} else {
    // Log database error
    error_log(date('Y-m-d H:i:s') . " - DB INSERT FAILED: " . $stmt->error . "\n", 3, 'mpesa_log.log');
}

$conn->close();

// FINAL RESPONSE: Always return success to M-Pesa regardless of internal processing result
echo json_encode(['ResultCode' => 0, 'ResultDesc' => 'Accepted']);
?>