<style>
    table {
        width: 100%;
        border-collapse: collapse;
        font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
    }

    th, td {
        padding: 10px;
        text-align: left;
        border-bottom: 1px solid #ddd;
    }

    th {
        background-color: #4CAF50;
        color: white;
    }
</style>
<div>

    <table class="">
        <caption>
            <?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.transaction',2)); ?>

            <?php if(!empty($start_date)): ?>
                for period: <?php echo e($start_date); ?> to <?php echo e($end_date); ?>

            <?php endif; ?>
        </caption>
        <thead>
        <tr class="">
            <th><?php echo e(trans_choice('general.borrower',1)); ?></th>
            <th><?php echo e(trans_choice('general.account',1)); ?></th>
            <th><?php echo e(trans_choice('general.product',1)); ?></th>
            <th><?php echo e(trans_choice('general.type',1)); ?></th>
            <th><?php echo e(trans_choice('general.debit',1)); ?></th>
            <th><?php echo e(trans_choice('general.credit',1)); ?></th>
            <th><?php echo e(trans_choice('general.date',2)); ?></th>
            <th><?php echo e(trans_choice('general.receipt',1)); ?></th>
            <th><?php echo e(trans_choice('general.payment',1)); ?> <?php echo e(trans_choice('general.method',1)); ?></th>
        </tr>
        </thead>
        <tbody>
        <?php
        $total_deposited = 0;
        $total_withdrawn = 0;
        $cr = 0;
        $dr = 0;
        ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
            $dr = $dr + $key->debit;
            $cr = $cr + $key->credit;
            ?>
            <tr>

                <td>
                    <?php if(!empty($key->borrower)): ?>
                        <?php echo e($key->borrower->first_name); ?> <?php echo e($key->borrower->last_name); ?>

                    <?php endif; ?>
                </td>
                <td><?php echo e($key->savings_id); ?></td>
                <td>
                    <?php if(!empty($key->savings)): ?>
                        <?php if(!empty($key->savings->savings_product)): ?>
                            <?php echo e($key->savings->savings_product->name); ?>

                        <?php endif; ?>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if($key->type=='deposit'): ?>
                        <?php echo e(trans_choice('general.deposit',1)); ?>

                    <?php endif; ?>
                    <?php if($key->type=='withdrawal'): ?>
                        <?php echo e(trans_choice('general.withdrawal',1)); ?>

                    <?php endif; ?>
                    <?php if($key->type=='bank_fees'): ?>
                        <?php echo e(trans_choice('general.charge',1)); ?>

                    <?php endif; ?>
                    <?php if($key->type=='interest'): ?>
                        <?php echo e(trans_choice('general.interest',1)); ?>

                    <?php endif; ?>
                    <?php if($key->type=='dividend'): ?>
                        <?php echo e(trans_choice('general.dividend',1)); ?>

                    <?php endif; ?>
                    <?php if($key->type=='transfer'): ?>
                        <?php echo e(trans_choice('general.transfer',1)); ?>

                    <?php endif; ?>
                    <?php if($key->type=='guarantee'): ?>
                        <?php echo e(trans_choice('general.on',1)); ?> <?php echo e(trans_choice('general.hold',1)); ?>

                    <?php endif; ?>
                    <?php if($key->reversed==1): ?>
                        <?php if($key->reversal_type=="user"): ?>
                            <span class="text-danger"><b>(<?php echo e(trans_choice('general.user',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                    )</b></span>
                        <?php endif; ?>
                        <?php if($key->reversal_type=="system"): ?>
                            <span class="text-danger"><b>(<?php echo e(trans_choice('general.system',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                    )</b></span>
                        <?php endif; ?>
                    <?php endif; ?>
                </td>
                <td><?php echo e(number_format($key->debit,2)); ?></td>
                <td><?php echo e(number_format($key->credit,2)); ?></td>
                <td><?php echo e($key->date); ?></td>
                <td><?php echo e($key->receipt); ?></td>
                <td>
                    <?php if(!empty($key->payment_method)): ?>
                        <?php echo e($key->payment_method->name); ?>

                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td><b><?php echo e(number_format($dr,2)); ?></b></td>
            <td><b><?php echo e(number_format($cr,2)); ?></b></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
        </tfoot>
    </table>
</div>