
<?php $__env->startSection('title'); ?><?php echo e(trans_choice('general.overview',1)); ?> <?php echo e(trans_choice('general.report',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title">
                <?php echo e(trans_choice('general.overview',1)); ?> <?php echo e(trans_choice('general.report',1)); ?>

                <?php if(!empty($start_date)): ?>
                    for period: <b><?php echo e($start_date); ?> to <?php echo e($end_date); ?></b>
                <?php endif; ?>
            </h6>

            <div class="heading-elements">
                <button class="btn btn-sm btn-info hidden-print"
                        onclick="window.print()"><?php echo e(trans_choice('general.print',1)); ?></button>
            </div>
        </div>
        <div class="panel-body hidden-print">
            <h4 class=""><?php echo e(trans_choice('general.date',1)); ?> <?php echo e(trans_choice('general.range',1)); ?></h4>
            <?php echo Form::open(array('url' => Request::url(), 'method' => 'post','class'=>'form-horizontal', 'name' => 'form')); ?>

            <div class="row">
                <div class="col-xs-5">
                    <?php echo Form::text('start_date',null, array('class' => 'form-control date-picker', 'placeholder'=>"From Date",'required'=>'required')); ?>

                </div>
                <div class="col-xs-1  text-center" style="padding-top: 5px;">
                    to
                </div>
                <div class="col-xs-5">
                    <?php echo Form::text('end_date',null, array('class' => 'form-control date-picker', 'placeholder'=>"To Date",'required'=>'required')); ?>

                </div>
            </div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-xs-2">
                        <span class="input-group-btn">
                          <button type="submit" class="btn bg-olive btn-flat"><?php echo e(trans_choice('general.search',1)); ?>!
                          </button>
                        </span>
                        <span class="input-group-btn">
                          <a href="<?php echo e(Request::url()); ?>"
                             class="btn bg-purple  btn-flat pull-right"><?php echo e(trans_choice('general.reset',1)); ?>!</a>
                        </span>
                    </div>
                </div>
            </div>
            <?php echo Form::close(); ?>


        </div>
        <!-- /.panel-body -->

    </div>
    <!-- /.box -->
    <div class="row">
        <div class="col-md-4">
            <div class="panel panel-success">
                <div class="panel-heading">
                    <h3 class="panel-title"><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.check_in',1)); ?></h3>
                    <!-- /.panel-tools -->
                </div>
                <!-- /.panel-header -->
                <div class="panel-body">
                    <?php echo e(number_format(\App\Helpers\GeneralHelper::check_ins_total_amount($start_date,$end_date),2)); ?>

                </div>
                <!-- /.panel-body -->
            </div>
            <!-- /.panel -->
        </div>
        <div class="col-md-4">
            <div class="panel panel-info">
                <div class="panel-heading">
                    <h3 class="panel-title"><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.check_out',1)); ?></h3>
                    <!-- /.panel-tools -->
                </div>
                <!-- /.panel-header -->
                <div class="panel-body">
                    <?php echo e(number_format(\App\Helpers\GeneralHelper::check_outs_total_amount($start_date,$end_date),2)); ?>

                </div>
                <!-- /.panel-body -->
            </div>
            <!-- /.panel -->
        </div>

        <div class="col-md-4">
            <div class="panel panel-success panel-solid">
                <div class="panel-heading">
                    <h3 class="panel-title"><?php echo e(trans_choice('general.profit',1)); ?></h3>
                    <!-- /.panel-tools -->
                </div>
                <!-- /.panel-header -->
                <div class="panel-body">
                    <?php echo e(number_format(\App\Helpers\GeneralHelper::check_outs_total_amount($start_date,$end_date)-\App\Helpers\GeneralHelper::check_ins_total_amount($start_date,$end_date),2)); ?>

                </div>
                <!-- /.panel-body -->
            </div>
            <!-- /.box -->
        </div>
    </div>

    <h4>Monthly </h4>
    <div class="row">
        <div class="col-md-12">
            <!-- AREA CHART -->
            <!-- LINE CHART -->
            <div class="panel panel-white">
                <div class="panel-heading">
                    <h3 class="panel-title"><span
                                style="color: #370fc6"><?php echo e(trans_choice('general.check_in',1)); ?></span>
                        /
                        <span style="color: #00a65a"><?php echo e(trans_choice('general.check_out',1)); ?> </span>
                    </h3>

                    <div class="heading-elements">

                    </div>
                </div>
                <div class="panel-body" style="display: block;">
                    <div id="operatingProfit" style="height: 350px;">

                    </div>
                </div>
                <!-- /.panel-body -->
            </div>
            <!-- /.box -->
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script src="<?php echo e(asset('assets/plugins/amcharts/amcharts.js')); ?>"
            type="text/javascript"></script>
    <script src="<?php echo e(asset('assets/plugins/amcharts/serial.js')); ?>"
            type="text/javascript"></script>
    <script src="<?php echo e(asset('assets/plugins/amcharts/pie.js')); ?>"
            type="text/javascript"></script>
    <script src="<?php echo e(asset('assets/plugins/amcharts/themes/light.js')); ?>"
            type="text/javascript"></script>
    <script>
        AmCharts.makeChart("operatingProfit", {
            "type": "serial",
            "theme": "light",
            "autoMargins": true,
            "marginLeft": 30,
            "marginRight": 8,
            "marginTop": 10,
            "marginBottom": 26,
            "fontFamily": 'Open Sans',
            "color": '#888',

            "dataProvider": <?php echo $monthly_stats; ?>,
            "valueAxes": [{
                "axisAlpha": 0,

            }],
            "startDuration": 1,
            "graphs": [{
                "balloonText": "<span style='font-size:13px;'>[[title]] in [[category]]:<b> [[value]]</b> [[additional]]</span>",
                "bullet": "round",
                "bulletSize": 8,
                "lineColor": "#370fc6",
                "lineThickness": 4,
                "title": "<?php echo e(trans_choice('general.check_in',1)); ?> <?php echo e(trans_choice('general.item',2)); ?>",
                "type": "smoothedLine",
                "valueField": "check_in"
            }, {
                "balloonText": "<span style='font-size:13px;'>[[title]] in [[category]]:<b> [[value]]</b> [[additional]]</span>",
                "bullet": "round",
                "bulletSize": 8,
                "lineColor": "#1bd126",
                "lineThickness": 4,
                "title": "<?php echo e(trans_choice('general.check_out',1)); ?> <?php echo e(trans_choice('general.item',2)); ?>",
                "type": "smoothedLine",
                "valueField": "check_out"
            }],
            "categoryField": "month",
            "categoryAxis": {
                "gridPosition": "start",
                "axisAlpha": 0,
                "tickLength": 0,
                "labelRotation": 30,

            }


        }).addLegend(new AmCharts.AmLegend());
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>