
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.transaction',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title"><?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.transaction',2)); ?></h6>

            <div class="heading-elements">

            </div>
        </div>
        <div class="panel-body ">
            <div class="table-responsive">
                <table id="repayments-data-table" class="table  table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>
                            <?php echo e(trans_choice('general.id',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.date',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.submitted',1)); ?> <?php echo e(trans_choice('general.on',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.type',1)); ?>

                        </th>

                        <th>
                            <?php echo e(trans_choice('general.debit',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.credit',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.detail',2)); ?>

                        </th>
                        <th class="text-center">
                            <?php echo e(trans_choice('general.action',1)); ?>

                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key->id); ?></td>
                            <td><?php echo e($key->date); ?> <?php echo e($key->time); ?></td>
                            <td><?php echo e($key->created_at); ?></td>
                            <td>
                                <?php if($key->type=='deposit'): ?>
                                    <?php echo e(trans_choice('general.deposit',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='withdrawal'): ?>
                                    <?php echo e(trans_choice('general.withdrawal',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='bank_fees'): ?>
                                    <?php echo e(trans_choice('general.charge',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='interest'): ?>
                                    <?php echo e(trans_choice('general.interest',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='dividend'): ?>
                                    <?php echo e(trans_choice('general.dividend',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='transfer'): ?>
                                    <?php echo e(trans_choice('general.transfer',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='transfer_fund'): ?>
                                    <?php echo e(trans_choice('general.transfer',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='transfer_loan'): ?>
                                    <?php echo e(trans_choice('general.transfer',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='guarantee'): ?>
                                    <?php echo e(trans_choice('general.on',1)); ?> <?php echo e(trans_choice('general.hold',1)); ?>

                                <?php endif; ?>
                                <?php if($key->reversed==1): ?>
                                    <?php if($key->reversal_type=="user"): ?>
                                        <span class="text-danger"><b>(<?php echo e(trans_choice('general.user',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                                )</b></span>
                                    <?php endif; ?>
                                    <?php if($key->reversal_type=="system"): ?>
                                        <span class="text-danger"><b>(<?php echo e(trans_choice('general.system',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                                )</b></span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(number_format($key->debit,2)); ?></td>
                            <td><?php echo e(number_format($key->credit,2)); ?></td>
                            <td><?php echo e($key->receipt); ?></td>
                            <td class="text-center">
                                <ul class="icons-list">
                                    <li class="dropdown">
                                        <a href="#" class="dropdown-toggle"
                                           data-toggle="dropdown">
                                            <i class="icon-menu9"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right">
                                            <?php if($key->reversed==0): ?>
                                                <li>
                                                    <a href="<?php echo e(url('saving/savings_transaction/'.$key->id.'/show')); ?>"><i
                                                                class="fa fa-search"></i> <?php echo e(trans_choice('general.view',1)); ?>

                                                    </a></li>
                                                <li>
                                                    <a href="<?php echo e(url('saving/savings_transaction/'.$key->id.'/print')); ?>"
                                                       target="_blank"><i
                                                                class="icon-printer"></i> <?php echo e(trans_choice('general.print',1)); ?> <?php echo e(trans_choice('general.receipt',1)); ?>

                                                    </a></li>
                                                <li>
                                                    <a href="<?php echo e(url('saving/savings_transaction/'.$key->id.'/pdf')); ?>"
                                                       target="_blank"><i
                                                                class="icon-file-pdf"></i> <?php echo e(trans_choice('general.pdf',1)); ?> <?php echo e(trans_choice('general.receipt',1)); ?>

                                                    </a></li>
                                            <?php endif; ?>
                                            <?php if($key->reversed==0 && $key->reversible==1): ?>

                                                <li>
                                                    <a href="<?php echo e(url('saving/savings_transaction/'.$key->id.'/edit')); ?>"><i
                                                                class="fa fa-edit"></i> <?php echo e(trans('general.edit')); ?>

                                                    </a></li>
                                                <li>
                                                    <a href="<?php echo e(url('saving/savings_transaction/'.$key->id.'/reverse')); ?>"
                                                       class="delete"><i
                                                                class="fa fa-minus-circle"></i> <?php echo e(trans('general.reverse')); ?>

                                                    </a></li>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- /.panel-body -->
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>

    <script>
        $('#repayments-data-table').DataTable({
            dom: '<"datatable-header"fl><"datatable-scroll"t><"datatable-footer"ip>',
            autoWidth: false,
            columnDefs: [{
                orderable: false,
                width: '100px',
                targets: [7]
            }],
            "order": [[1, "asc"]],
            language: {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>:",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            drawCallback: function () {
                $('.delete').on('click', function (e) {
                    e.preventDefault();
                    var href = $(this).attr('href');
                    swal({
                        title: 'Are you sure?',
                        text: '',
                        type: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Ok',
                        cancelButtonText: 'Cancel'
                    }).then(function () {
                        window.location = href;
                    })
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>