
<?php $__env->startSection('title'); ?><?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.transaction',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title"><?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.transaction',1)); ?></h6>

            <div class="heading-elements">

            </div>
        </div>
        <div class="panel-body">
            <div class="col-md-6">
                <table class="table table-striped table-hover">
                    <tr>
                        <td><?php echo e(trans_choice('general.borrower',1)); ?></td>
                        <td class=""><?php echo e($savings_transaction->borrower->title); ?>

                            <?php echo e($savings_transaction->borrower->first_name); ?> <?php echo e($savings_transaction->borrower->last_name); ?>

                        </td>
                    </tr>
                    <tr>
                        <td><?php echo e(trans_choice('general.id',1)); ?></td>
                        <td><?php echo e($savings_transaction->id); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(trans_choice('general.type',1)); ?></td>
                        <td>
                            <?php if($savings_transaction->type=='deposit'): ?>
                                <?php echo e(trans_choice('general.deposit',1)); ?>

                            <?php endif; ?>
                            <?php if($savings_transaction->type=='withdrawal'): ?>
                                <?php echo e(trans_choice('general.withdrawal',1)); ?>

                            <?php endif; ?>
                            <?php if($savings_transaction->type=='bank_fees'): ?>
                                <?php echo e(trans_choice('general.charge',1)); ?>

                            <?php endif; ?>
                            <?php if($savings_transaction->type=='interest'): ?>
                                <?php echo e(trans_choice('general.interest',1)); ?>

                            <?php endif; ?>
                            <?php if($savings_transaction->type=='dividend'): ?>
                                <?php echo e(trans_choice('general.dividend',1)); ?>

                            <?php endif; ?>
                            <?php if($savings_transaction->type=='transfer'): ?>
                                <?php echo e(trans_choice('general.transfer',1)); ?>

                            <?php endif; ?>
                            <?php if($savings_transaction->type=='transfer_fund'): ?>
                                <?php echo e(trans_choice('general.transfer',1)); ?>

                            <?php endif; ?>
                            <?php if($savings_transaction->type=='transfer_loan'): ?>
                                <?php echo e(trans_choice('general.transfer',1)); ?>

                            <?php endif; ?>
                            <?php if($savings_transaction->type=='guarantee'): ?>
                                <?php echo e(trans_choice('general.on',1)); ?> <?php echo e(trans_choice('general.hold',1)); ?>

                            <?php endif; ?>
                            <?php if($savings_transaction->reversed==1): ?>
                                <?php if($savings_transaction->reversal_type=="user"): ?>
                                    <span class="text-danger"><b>(<?php echo e(trans_choice('general.user',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                            )</b></span>
                                <?php endif; ?>
                                <?php if($savings_transaction->reversal_type=="system"): ?>
                                    <span class="text-danger"><b>(<?php echo e(trans_choice('general.system',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                            )</b></span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><?php echo e(trans_choice('general.date',1)); ?></td>
                        <td><?php echo e($savings_transaction->date); ?> <?php echo e($savings_transaction->time); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(trans_choice('general.amount',1)); ?></td>
                        <td>
                            <?php if($savings_transaction->credit>$savings_transaction->debit): ?>
                                <?php echo e(number_format($savings_transaction->credit,2)); ?>

                            <?php else: ?>
                                <?php echo e(number_format($savings_transaction->debit,2)); ?>

                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php if(!empty($savings_transaction->receipt)): ?>
                        <tr>
                            <td><?php echo e(trans_choice('general.receipt',1)); ?></td>
                            <td>
                                <?php echo e($savings_transaction->receipt); ?>

                            </td>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <td><?php echo e(trans_choice('general.note',2)); ?></td>
                        <td>
                            <?php echo e($savings_transaction->notes); ?>

                        </td>
                    </tr>

                </table>
            </div>
        </div>
        <!-- /.panel-body -->
        <div class="panel-footer">
            <div class="heading-elements">
                <a href="<?php echo e(url()->previous()); ?>"
                   class="btn btn-primary pull-right"><?php echo e(trans_choice('general.back',1)); ?></a>
            </div>
        </div>
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>