
<?php $__env->startSection('title'); ?>
    <?php echo e(trans('general.dashboard')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="panel panel-white">
        <div class="panel-body">
            <div class="row">
                <div class="col-sm-3 col-xs-6">
                    <div class="description-block border-right">
                        <?php if(\App\Models\Setting::where('setting_key', 'currency_position')->first()->setting_value=='left'): ?>
                            <h5 class="description-header"> <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?> <?php echo e(number_format(\App\Helpers\GeneralHelper::borrower_loans_total_due($borrower->id))); ?> </h5>
                        <?php else: ?>
                            <h5 class="description-header"> <?php echo e(number_format(\App\Helpers\GeneralHelper::borrower_loans_total_due($borrower->id))); ?>  <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?></h5>
                        <?php endif; ?>
                        <span class="description-text"><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.value',1)); ?></span>
                    </div>
                    <!-- /.description-block -->
                </div>
                <!-- /.col -->
                <div class="col-sm-3 col-xs-6">
                    <div class="description-block border-right">
                        <?php if(\App\Models\Setting::where('setting_key', 'currency_position')->first()->setting_value=='left'): ?>
                            <h5 class="description-header"> <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?> <?php echo e(number_format(\App\Helpers\GeneralHelper::borrower_loans_total_paid($borrower->id))); ?> </h5>
                        <?php else: ?>
                            <h5 class="description-header"> <?php echo e(number_format(\App\Helpers\GeneralHelper::borrower_loans_total_paid($borrower->id))); ?> <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?></h5>
                        <?php endif; ?>
                        <span class="description-text"><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.paid',1)); ?></span>
                    </div>
                    <!-- /.description-block -->
                </div>
                <!-- /.col -->
                <div class="col-sm-3 col-xs-6">
                    <div class="description-block border-right">
                        <?php if(\App\Models\Setting::where('setting_key', 'currency_position')->first()->setting_value=='left'): ?>
                            <h5 class="description-header"> <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?> <?php echo e(number_format(\App\Helpers\GeneralHelper::borrower_loans_total_due($borrower->id)-\App\Helpers\GeneralHelper::borrower_loans_total_paid($borrower->id))); ?> </h5>
                        <?php else: ?>
                            <h5 class="description-header"> <?php echo e(number_format(\App\Helpers\GeneralHelper::borrower_loans_total_due($borrower->id)-\App\Helpers\GeneralHelper::borrower_loans_total_paid($borrower->id))); ?>  <?php echo e(\App\Models\Setting::where('setting_key', 'currency_symbol')->first()->setting_value); ?></h5>
                        <?php endif; ?>
                        <span class="description-text"><?php echo e(trans_choice('general.balance',1)); ?></span>

                    </div>
                    <!-- /.description-block -->
                </div>
                <!-- /.col -->
                <div class="col-sm-3 col-xs-6">
                    <div class="description-block">
                        <?php if(!empty(\App\Models\LoanSchedule::where('due_date','>',date('Y-m-d'))->first())): ?>
                            <h5 class="description-header"
                                style="font-weight: 300;color: #ff5f5f;"><?php echo e(\App\Models\LoanSchedule::where('due_date','>',date('Y-m-d'))->orderBy('due_date','asc')->first()->due_date); ?></h5>
                        <?php endif; ?>
                        <span class="description-text"><?php echo e(trans_choice('general.next_payment_due',1)); ?></span>
                    </div>
                    <!-- /.description-block -->
                </div>
            </div>
            <!-- /.row -->
        </div>
    </div>

    <div class="row">

        <div class="col-md-7">

            <div class="panel panel-white">
                <div class="panel-heading">
                    <h6 class="panel-title"><?php echo e(trans_choice('general.loan',2)); ?></h6>

                    <div class="heading-elements">

                    </div>
                </div>
                <div class="panel-body table-responsive ">
                    <table id="loan-data-table" class="table  table-condensed">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(trans_choice('general.principal',1)); ?></th>
                            <th><?php echo e(trans_choice('general.balance',1)); ?></th>
                            <th><?php echo e(trans_choice('general.released',1)); ?></th>
                            <th><?php echo e(trans_choice('general.status',1)); ?></th>
                            <th><?php echo e(trans_choice('general.action',1)); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $borrower->loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>

                                <td><?php echo e($key->id); ?></td>
                                <td><?php echo e(number_format($key->principal,2)); ?></td>
                                <td><?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_balance($key->id),2)); ?></td>
                                <td><?php echo e($key->release_date); ?></td>


                                <td>
                                    <?php if($key->maturity_date<date("Y-m-d") && \App\Helpers\GeneralHelper::loan_total_balance($key->id)>0): ?>
                                        <span class="label label-danger"><?php echo e(trans_choice('general.past_maturity',1)); ?></span>
                                    <?php else: ?>
                                        <?php if($key->status=='pending'): ?>
                                            <span class="label label-warning"><?php echo e(trans_choice('general.pending',1)); ?> <?php echo e(trans_choice('general.approval',1)); ?></span>
                                        <?php endif; ?>
                                        <?php if($key->status=='approved'): ?>
                                            <span class="label label-info"><?php echo e(trans_choice('general.awaiting',1)); ?> <?php echo e(trans_choice('general.disbursement',1)); ?></span>
                                        <?php endif; ?>
                                        <?php if($key->status=='disbursed'): ?>
                                            <span class="label label-info"><?php echo e(trans_choice('general.active',1)); ?></span>
                                        <?php endif; ?>
                                        <?php if($key->status=='declined'): ?>
                                            <span class="label label-danger"><?php echo e(trans_choice('general.declined',1)); ?></span>
                                        <?php endif; ?>
                                        <?php if($key->status=='withdrawn'): ?>
                                            <span class="label label-danger"><?php echo e(trans_choice('general.withdrawn',1)); ?></span>
                                        <?php endif; ?>
                                        <?php if($key->status=='written_off'): ?>
                                            <span class="label label-danger"><?php echo e(trans_choice('general.written_off',1)); ?></span>
                                        <?php endif; ?>
                                        <?php if($key->status=='closed'): ?>
                                            <span class="label label-success"><?php echo e(trans_choice('general.closed',1)); ?></span>
                                        <?php endif; ?>
                                        <?php if($key->status=='pending_reschedule'): ?>
                                            <span class="label label-warning"><?php echo e(trans_choice('general.pending',1)); ?> <?php echo e(trans_choice('general.reschedule',1)); ?></span>
                                        <?php endif; ?>
                                        <?php if($key->status=='rescheduled'): ?>
                                            <span class="label label-info"><?php echo e(trans_choice('general.rescheduled',1)); ?></span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(url('client/loan/'.$key->id.'/show')); ?>"
                                       class="btn btn-info btn-xs legitRipple" data-toggle="tooltip"
                                       data-title="<?php echo e(trans_choice('general.detail',2)); ?>"><i
                                                class="fa fa-search"></i>
                                    </a>
                                    <?php if(\App\Models\Setting::where('setting_key','enable_online_payment')->first()->setting_value==1 && \App\Helpers\GeneralHelper::loan_total_balance($key->id)>0): ?>
                                        <a href="<?php echo e(url('client/loan/'.$key->id.'/pay')); ?>"
                                           class="btn btn-success btn-xs legitRipple" data-toggle="tooltip"
                                           data-title="<?php echo e(trans('general.pay')); ?>"><i
                                                    class="fa fa-money"></i>
                                        </a>
                                    <?php endif; ?>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-5">
            <div class="panel panel-white">
                <div class="panel-heading">
                    <h6 class="panel-title"><?php echo e(trans_choice('general.repayment',2)); ?></h6>

                    <div class="heading-elements">

                    </div>
                </div>
                <div class="panel-body table-responsive">
                    <table id="view-repayments"
                           class="table table-condensed">
                        <thead>
                        <tr role="row">
                            <th>
                                <?php echo e(trans_choice('general.collection',1)); ?> <?php echo e(trans_choice('general.date',1)); ?>

                            </th>
                            <th>
                                <?php echo e(trans_choice('general.method',1)); ?>

                            </th>
                            <th>
                                <?php echo e(trans_choice('general.amount',1)); ?>

                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = \App\Models\LoanTransaction::where('transaction_type',
            'repayment')->where('reversed', 0)->where('borrower_id', $borrower->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                            <tr>
                                <td><?php echo e($key->date); ?></td>
                                <td>
                                    <?php if(!empty($key->loan_repayment_method)): ?>
                                        <?php echo e($key->loan_repayment_method->name); ?>

                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(number_format($key->credit,2)); ?></td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function () {

        });
    </script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>
        $('#loan-data-table').DataTable({
            "order": [[0, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": [5]}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
        $('#view-repayments').DataTable({
            "order": [[0, "asc"]],
            "columnDefs": [
                {"orderable": false, "targets": []}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            responsive: false
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('client.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>